//___________________________________
//                                   \
// Bibliotheca save Variables Engine.  version 1.1	$Id: bibliotheca.js 59 2007-09-09 06:43:33Z nilton $
//___________________________________/
/*
	This library lets you save/load complex object variables from/to a save file.

	Usage:
	RequireScript("bibliotheca.js");
	var sav = new Bibliotheca("slot1.sav");
	var myvar = {num:55,str:'ab\'"cd', obj:{bool:true,num:1}, f:function(i){i++;}};
	var myarr = new Array(6);
	var mystr = "This is a string";
	sav.OpenFile(); // it's optional to call this statement
	sav.storeFunctions=false; //Not interested in functions (true by default).
	this.getRealObject=true; // We are interested in the real object calling name. (this will recreate our non-saved functions)
	sav.store("myvar", "myarr"); //Store 2 variables, list can be as long as you want.
	sav.store("mystr"); //Store another variable. store() does not work with local variables
	sav.store("mystr"); //Overwrite information (no double entries :) )
	sav.storeNamed(myvar, "myvar_old"); //Store in a renamed variable. storeNamed() works with local variables.
	sav.flush(); //save to disk, important! (its optional if you just use close() )
	sav.close(); //Close the file, no more writing to it (it's autoflushed).
	Abort("the file " + sav.filename + " has been saved.");

	//Now, you should have a human readable file called 'slot1.sav'

	Then, later:
	RequireScript("bibliotheca.js"); //If not already called
	var sav = new Bibliotheca(); //Maybe we dont know the filename yet...
	sav.OpenFile("slot1.sav"); //Open this file for reading/writing.
	sav.restore(); //restores all saved variables. (myvar, mynum and mystr)
	sav.restore("myvar"); // only restores myvar (and everything in it)
	sav.restore("myvar.num", "myvar.f") //restore only part of an object  
	sav.close();

	You can also use sav.storeNamed():
	sav.storeNamed( myvar,"myvar", myarr,"myarr" ); //Store 2 variables, list can be as long as you want.
	This version requires 2 parameters for each variable saved. First the variable, then a string of 
	the name to store it with, which usually is the same name. Because you pass the real variable to 
	storeNamed, it does not have the limitation store() has [see bugs].

	bugs: 
	If you get "Reference Error: The variable is not defined":
	The variable saved must be in the same lexial scope as the Bibliotheca object. (this usually means global)
	If you cant work around this, remove the "var" before your variable declaration. so:
	var mynum = 64;  becomes:  mynum = 64;
	Or use .storeNamed(), as it has no problems with scope.

	Multiline strings are a problem, you can save them, but they corrupt the file.

	And just dont store binary data or very big objects like:
	I=GetPersonSpriteset(sprite); sav.store("I");
	Date() seems to be a protected type, could not save such an object?

	About storeFunctions and getRealObject.
	When getRealObject=false, then all objects will be created as: var=new Object(); this is
	save for data-only objects. But if you have functions (methods) defined in your object, then
	1: you either save the functions (redundant information) or 
	2:You call the original constructor, and hope its defined already. 

	Note that there is no "delete", store() will replace/append only.
*/

function Bibliotheca(filename)
{
 if(this instanceof Bibliotheca == false) {return new Bibliotheca(filename);}
 this.filename=filename||"noname.sav";
 this.file = undefined; //holds the file_object that reads/writes.
 this.storeFunctions=true;
 this.getRealObject=true;
}

Bibliotheca.prototype.OpenFile = function(filename) {
	this.filename=filename||this.filename; 
	this.file = OpenFile(this.filename); 
}

Bibliotheca.prototype.setFilename=function(filename) {
	this.filename=filename;
}


//todo: replace this by new Sphere primitives
Bibliotheca.prototype.FileExists = function(filename) {
	filename = filename||this.filename;
	var FileArr = GetFileList();
	var i=FileArr.length-1;
	do{
		if(FileArr[i]=filename)return true;
	}while(i--);
	return false;
}

Bibliotheca.prototype.flush = function() { this.file.flush(); }
Bibliotheca.prototype.close = function() { this.file.flush(); this.file.close(); }

Bibliotheca.prototype.store = function() {
	if(typeof this.file =='undefined')this.OpenFile();
	for (var j=0; j<arguments.length; ++j) {
		var it=arguments[j];
		try {
			var eit= eval(it);
		}
		catch (e) {
			Abort("storeItem could not store the undefined variable '"+it+"'. \n"+e);
		}
		if(!this.storeFunctions&&typeof eit == 'function')continue;
		switch(typeof eit){
			case 'undefined': this.file.write(it,undefined);break;
			case 'boolean':
			case 'number': this.file.write(it,eit); break;
			case 'string': this.file.write(it,'"'+eit.replace(/"/g,"\\\"")+'"'); break;
			case 'function': this.file.write(it,eit.toString().replace(/\n\s*/g," ")); break;
			default:
				if(this.getRealObject) this.file.write(it,"new "+this.getObjType(eit)+"()");
				else this.file.write(it,"new Object()");
				for(var i in eit) {this.store(it+'["'+i+'"]');}
			break;
		}
	}
}


Bibliotheca.prototype.storeNamed = function() {
	if(typeof this.file =='undefined')this.OpenFile();
	if(arguments.length%2)Abort("Bibliotheca: storeNamed(): Arguments must be given in pairs!");
	for (var j=0; j<arguments.length; j+=2) {
		var it=arguments[j+1];
		var eit=arguments[j];

		if(!this.storeFunctions&&typeof eit == 'function')continue;
		switch(typeof eit){
			case 'undefined': this.file.write(it,undefined);break;
			case 'boolean':
			case 'number': this.file.write(it,eit); break;
			case 'string': this.file.write(it,'"'+eit.replace(/"/g,"\\\"")+'"'); break;
			case 'function': this.file.write(it,eit.toString().replace(/\n\s*/g," ")); break;
			default:
				if(this.getRealObject) this.file.write(it,"new "+this.getObjType(eit)+"()");
				else this.file.write(it,"new Object()");
				for(var i in eit) {this.storeNamed(eit[i],it+'["'+i+'"]');}
			break;
		}
	}
}

Bibliotheca.prototype.restore = function() {
	if(typeof this.file =='undefined')this.OpenFile();
	for (var i=0; i<this.file.getNumKeys(); ++i){
		var it=this.file.getKey(i);
		if(arguments[0]){
			var cont=true;
			for (var j=0; j<arguments.length; ++j) {if(it.match(RegExp("^"+arguments[j])))cont=false;}
			if(cont)continue;
		}
		val=this.file.read(it,undefined);
		eval(it+'='+val);
	}
}

// RequireScript("lib/objects.js");  //We use getObjType() from this library.
Bibliotheca.prototype.getObjType = function() {
	if(typeof v != 'object')
		return(typeof v);
	if(v==null)
		return null;
	var A=v.constructor.toString().match(/function (\w+)/);
	if(A && A[1]!="Object")
		return A[1];
	A = v.toString().match(/\[object (\w+)\]/);
	if(A)
		return A[1];
	return typeof(v);
}
